<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Nunito:ital,wght@0,200..1000;1,200..1000&display=swap" rel="stylesheet">

    <title>Privacy Policy - ArloMusic</title>
    <style>
        body {
            font-family: 'Nunito', sans-serif;
            color: white;
        }



        /* Privacy Policy styling */
        .policy-section {
            margin-bottom: 20px;
        }

        .policy-section h2 {
            font-size: 1.8em;
            color: #007bff;
            margin-bottom: 10px;
        }

        .policy-section p, .policy-section ul {
            font-size: 1em;
            color: white;
            margin: 10px 0;
        }
        /* Mobile menu styling */
@media (max-width: 768px) {
    html, body {
    overflow-x: hidden;
    }
       /* Hamburger icon styles */
       .hamburger {
    display: none;
    cursor: pointer;
    flex-direction: column;
    gap: 5px;
    padding: 10px;
    z-index: 10; /* Make sure the hamburger icon stays above the menu */
    }

    .hamburger .bar {
    width: 25px;
    height: 3px;
    background-color: white;
    transition: 0.4s;
    }

    .nav-links {
        position: fixed;
        top: 0px;
        right: -60%; /* Start off-screen */
        height: 100vh;
        width: 40%; /* Cover half the screen */
        background-color: #000000c7;
        border-left: 0.5px solid white;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
        transition: right 0.4s ease; /* Smooth slide-in effect */
        z-index: 9; /* Keep the menu below the hamburger icon */
    }

    .nav-links ul {
        flex-direction: column;
        width: 100%;
    }

    .nav-links ul li {
        display: block;
        padding: 15px 0;
        
    }

    /* Show hamburger icon only on mobile */
    .hamburger {
        display: flex;
    }

    /* When active, slide the menu into view */
    .nav-links.active {
        right: -7%;
        }
    
    .hamburger {
        display: flex;
        position: relative; /* Keeps it at the top right of the screen initially */
        right: 10px;
        z-index: 11; /* Above the menu */
    }

    /* Position hamburger icon "inside" menu when it’s open */
    .hamburger.active {
        position: fixed; /* Repositions icon relative to .nav-links */

        right: 10px;
        z-index: 11; /* Above the sliding menu content */
    }
    .Account{
        margin-left: -20px;
        margin-top: 10px;
    }
}
    </style>
</head>
<body>
    <section class="header" id="NavSection">
        <nav class="navbar">
            <a href="index.php"><img class="LogoIcon" src="Images/Logo1.png" alt="ArloMusic_Logo"></a>
            <div class="hamburger" id="hamburger" onclick="toggleMenu()">
        <div class="bar"></div>
        <div class="bar"></div>
        <div class="bar"></div>
            </div>
            <div class="nav-links" id="navLinks">
            <ul>
                <li class="navButton"><a href="index.php">Home</a></li>
                <li class="navButton"><a href="TopPage.php">Top</a></li>
                <li class="navButton"><a href="ArtistsPageNoLog.php">Artists</a></li>
                <li class="navButton"><a href="AccountCreate.php">Sign up</a></li>
                <li class="navButton"><a href="AccountLogin.php">Log in</a></li>
            </ul>
        </div>
        </nav>
        <div class="HeaderLow">
            <h1>Privacy Policy</h1>
            <div class="policy-section">
                <h2>1. Information We Collect</h2>
                <p><strong>1.1 Information You Provide</strong></p>
                <ul>
                    <li><strong>Account Information:</strong> When you create an account, we may collect personal details, such as your name, email address, username, and profile information.</li>
                    <li><strong>Content:</strong> If you upload music, share comments, or post on your profile, we collect any information you provide in connection with those actions.</li>
                </ul>
                <p><strong>1.2 Automatically Collected Information</strong></p>
                <ul>
                    <li><strong>Usage Data:</strong> We collect data on how you interact with our site, including pages viewed, time spent on each page, and interactions with features.</li>
                    <li><strong>Device and Log Information:</strong> We collect device information, including IP address, browser type, and system details, to ensure our site is working well across different devices and browsers.</li>
                </ul>
            </div>
            
            <div class="policy-section">
                <h2>2. How We Use Your Information</h2>
                <p>ArloMusic uses your information for the following purposes:</p>
                <ul>
                    <li><strong>To provide and improve our services:</strong> We use collected information to maintain and improve our services, deliver relevant content, and personalize your experience.</li>
                    <li><strong>To communicate with you:</strong> We may send account updates, important notifications, or service announcements. If you have opted in, we may also send you marketing messages.</li>
                    <li><strong>To enforce policies and prevent misuse:</strong> We may use information to detect and prevent abuse, fraud, and other harmful activity on our platform.</li>
                </ul>
            </div>

            <div class="policy-section">
                <h2>3. Sharing Your Information</h2>
                <p>ArloMusic does not sell, rent, or share your personal information with third parties, except in the following cases:</p>
                <ul>
                    <li><strong>Service Providers:</strong> We may share information with trusted third-party service providers who help us with website hosting, payment processing, analytics, and other services.</li>
                    <li><strong>Legal Requirements:</strong> We may share information if required by law, legal process, or to respond to government requests.</li>
                </ul>
            </div>

            <div class="policy-section">
                <h2>4. Cookies and Tracking Technologies</h2>
                <p>We use cookies and similar tracking technologies to personalize your experience, remember your preferences, and monitor site performance. You can control cookie preferences in your browser settings; however, some features of ArloMusic may not function properly without cookies.</p>
            </div>

            <div class="policy-section">
                <h2>5. Data Security</h2>
                <p>We implement reasonable technical and organizational measures to protect your personal information against unauthorized access, loss, or misuse. However, no internet transmission is entirely secure, and we cannot guarantee complete security of your data.</p>
            </div>

            <div class="policy-section">
                <h2>6. Your Choices and Rights</h2>
                <ul>
                    <li><strong>Access and Update:</strong> You can access and update your account information anytime by logging into your ArloMusic account.</li>
                    <li><strong>Delete Your Account:</strong> If you would like to delete your account, please contact us at [contact@arlomusic.com]. Note that some information may be retained for legal or security purposes.</li>
                    <li><strong>Opt-Out:</strong> You may unsubscribe from marketing emails at any time by following the unsubscribe link in the email.</li>
                </ul>
            </div>

            <div class="policy-section">
                <h2>7. Children’s Privacy</h2>
                <p>ArloMusic is not intended for users under the age of 13. We do not knowingly collect or solicit personal information from children under 13. If we discover we have collected such information, we will take steps to delete it.</p>
            </div>

            <div class="policy-section">
                <h2>8. Changes to This Privacy Policy</h2>
                <p>ArloMusic may update this Privacy Policy periodically. We will notify you of any significant changes by posting the new Privacy Policy on this page and updating the date at the top. Your continued use of ArloMusic signifies your acceptance of any changes.</p>
            </div>

            <div class="policy-section">
                <h2>9. Contact Us</h2>
                <p>If you have questions or concerns about this Privacy Policy or our data practices, please contact us at:</p>
                <p><strong>ArloMusic Support Team</strong><br>
                Email: <a href="mailto:contact@arlomusic.com">contact@arlomusic.com</a><br>
                Website: <a href="https://arlomusic.com">https://arlomusic.com</a></p>
            </div>
        </div>
        <br>
    </section>
    
    <hr>
    <section class="Footer">
        <div class="FooterContent">
            <div class="FooterLinks">
                <ul>
                <li><a href="index.php">About Us</a></li>
                    <li><a href="contact.php">Contact Us</a></li>
                    <li><a href="policy.php">Privacy Policy</a></li>
                    <li><a href="TOS.php">Terms of Service</a></li>
                </ul>
            </div>
            <div class="FooterSocials">
                <ul>
                    <li><a href=""><img src="Images/facebook.png" alt=""></a></li>
                    <li><a href=""><img src="Images/twitter.png" alt=""></a></li>
                    <li><a href=""><img src="Images/instagram.png" alt=""></a></li>
                </ul>
            </div>
        </div>
        <h1>Copyright © 2024 ArloMusic All rights reserved.</h1>
    </section>
    <script>
    function toggleMenu() {
        const navLinks = document.getElementById("navLinks");
        navLinks.classList.toggle("active");
        const hamburger = document.getElementById("hamburger");
        hamburger.classList.toggle("active");
    }
</script>
</body>
</html>